/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ChunkContainer;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.io.AsfExtHeaderModifier;
import org.jaudiotagger.audio.asf.io.AsfHeaderReader;
import org.jaudiotagger.audio.asf.io.AsfStreamer;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.RandomAccessFileInputstream;
import org.jaudiotagger.audio.asf.io.RandomAccessFileOutputStream;
import org.jaudiotagger.audio.asf.io.WriteableChunkModifer;
import org.jaudiotagger.audio.asf.util.TagConverter;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.generic.AudioFileWriter;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.asf.AsfTag;

public class AsfFileWriter
extends AudioFileWriter {
    @Override
    protected void deleteTag(RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotWriteException, IOException {
        this.writeTag(new AsfTag(true), raf, tempRaf);
    }

    private boolean[] searchExistence(ChunkContainer container, MetadataContainer[] metaContainers) {
        assert (container != null);
        assert (metaContainers != null);
        boolean[] result = new boolean[metaContainers.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = container.hasChunkByGUID(metaContainers[i].getContainerType().getContainerGUID());
        }
        return result;
    }

    @Override
    protected void writeTag(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        AsfHeader sourceHeader = AsfHeaderReader.readTagHeader(raf);
        raf.seek(0L);
        AsfTag copy = new AsfTag(tag, true);
        MetadataContainer[] distribution = TagConverter.distributeMetadata(copy);
        boolean[] existHeader = this.searchExistence(sourceHeader, distribution);
        boolean[] existExtHeader = this.searchExistence(sourceHeader.getExtendedHeader(), distribution);
        ArrayList<ChunkModifier> headerModifier = new ArrayList<ChunkModifier>();
        ArrayList<ChunkModifier> extHeaderModifier = new ArrayList<ChunkModifier>();
        for (int i = 0; i < distribution.length; ++i) {
            WriteableChunkModifer modifier = new WriteableChunkModifer(distribution[i]);
            if (existHeader[i]) {
                headerModifier.add(modifier);
                continue;
            }
            if (existExtHeader[i]) {
                extHeaderModifier.add(modifier);
                continue;
            }
            if (i == 0 || i == 2 || i == 1) {
                headerModifier.add(modifier);
                continue;
            }
            extHeaderModifier.add(modifier);
        }
        if (!extHeaderModifier.isEmpty()) {
            headerModifier.add(new AsfExtHeaderModifier(extHeaderModifier));
        }
        new AsfStreamer().createModifiedCopy(new RandomAccessFileInputstream(raf), new RandomAccessFileOutputStream(rafTemp), headerModifier);
    }
}

